package gov.va.vamf.scheduling.direct.serializer;


import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import gov.va.vamf.scheduling.direct.exception.XSSException;
import gov.va.vamf.scheduling.direct.utils.XSSSanitizer;
import gov.va.vamf.scheduling.direct.validator.XSSValidator;

import java.io.IOException;

public class XSSProtectionDeserializer extends StdDeserializer<String> {

    public XSSProtectionDeserializer() {
        super(String.class);
    }

    @Override
    public String deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {

        XSSValidator xssValidator = new XSSValidator();
        String encoded = null;

        String input = parser.getText();
        if (input != null && xssValidator.hasXSSInjection(input)) {
            throw new XSSException("XSS injection detected");
        } else {
            if (input != null) {
                encoded = XSSSanitizer.sanitize(input.trim());
            }
        }
        return encoded;
    }
}
